/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.neapolitan.common.world.gen.feature;

import com.minecraftabnormals.abnormals_core.core.util.TreeUtil;
import com.minecraftabnormals.neapolitan.common.block.BananaFrondBlock;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanBlocks;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class BananaPlantFeature
extends Feature<NoFeatureConfig> {
    public BananaPlantFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos pos, NoFeatureConfig config) {
        int i;
        BlockPos blockPos = pos;
        ArrayList<BlockPos> stalks = new ArrayList<BlockPos>();
        BlockPos upFrond = null;
        BlockPos bundle = null;
        int size = 3 + random.nextInt(4);
        HashMap<BlockPos, Direction> smallFronds = new HashMap<BlockPos, Direction>();
        HashMap<BlockPos, Direction> fronds = new HashMap<BlockPos, Direction>();
        HashMap<BlockPos, Direction> largeFronds = new HashMap<BlockPos, Direction>();
        for (i = 0; i < size; ++i) {
            stalks.add(blockPos);
            blockPos = blockPos.func_177984_a();
        }
        upFrond = blockPos;
        i = 0;
        if (!BananaPlantFeature.isValidGround((IWorldGenerationBaseReader)world, pos.func_177977_b())) {
            return false;
        }
        for (BlockPos stalk : stalks) {
            if (i >= size - 3) {
                for (Direction direction : Direction.values()) {
                    if (!direction.func_176740_k().func_176722_c()) continue;
                    if (i == size - 1) {
                        if (random.nextInt(4) != 0) {
                            largeFronds.put(stalk.func_177972_a(direction), direction);
                            continue;
                        }
                        fronds.put(stalk.func_177972_a(direction), direction);
                        continue;
                    }
                    if (i == size - 2) {
                        if (random.nextBoolean()) {
                            fronds.put(stalk.func_177972_a(direction), direction);
                            continue;
                        }
                        if (random.nextBoolean() && bundle == null) {
                            bundle = stalk.func_177972_a(direction);
                            continue;
                        }
                        smallFronds.put(stalk.func_177972_a(direction), direction);
                        continue;
                    }
                    if (i != size - 3 || random.nextInt(3) == 0) continue;
                    smallFronds.put(stalk.func_177972_a(direction), direction);
                }
            }
            ++i;
        }
        if (BananaPlantFeature.isAirAt((IWorldGenerationBaseReader)world, pos, size) && pos.func_177956_o() < world.func_217301_I() - size) {
            for (BlockPos blockPos2 : stalks) {
                TreeUtil.setForcedState((IWorldWriter)world, (BlockPos)blockPos2, (BlockState)((Block)NeapolitanBlocks.BANANA_STALK.get()).func_176223_P());
            }
            TreeUtil.setForcedState((IWorldWriter)world, (BlockPos)upFrond, (BlockState)((Block)NeapolitanBlocks.LARGE_BANANA_FROND.get()).func_176223_P());
            if (bundle != null) {
                TreeUtil.setForcedState((IWorldWriter)world, bundle, (BlockState)((Block)NeapolitanBlocks.BANANA_BUNDLE.get()).func_176223_P());
            }
            for (BlockPos blockPos2 : smallFronds.keySet()) {
                TreeUtil.setForcedState((IWorldWriter)world, (BlockPos)blockPos2, (BlockState)((BlockState)((Block)NeapolitanBlocks.SMALL_BANANA_FROND.get()).func_176223_P().func_206870_a((Property)BananaFrondBlock.FACING, (Comparable)smallFronds.get(blockPos2))));
            }
            for (BlockPos blockPos2 : fronds.keySet()) {
                TreeUtil.setForcedState((IWorldWriter)world, (BlockPos)blockPos2, (BlockState)((BlockState)((Block)NeapolitanBlocks.BANANA_FROND.get()).func_176223_P().func_206870_a((Property)BananaFrondBlock.FACING, (Comparable)fronds.get(blockPos2))));
            }
            for (BlockPos blockPos2 : largeFronds.keySet()) {
                TreeUtil.setForcedState((IWorldWriter)world, (BlockPos)blockPos2, (BlockState)((BlockState)((Block)NeapolitanBlocks.LARGE_BANANA_FROND.get()).func_176223_P().func_206870_a((Property)BananaFrondBlock.FACING, (Comparable)largeFronds.get(blockPos2))));
            }
            if (BananaPlantFeature.isGrass((IWorldGenerationBaseReader)world, pos.func_177977_b())) {
                TreeUtil.setForcedState((IWorldWriter)world, (BlockPos)pos.func_177977_b(), (BlockState)Blocks.field_150351_n.func_176223_P());
                for (BlockPos blockpos : BlockPos.func_191531_b((int)(pos.func_177958_n() - 3), (int)(pos.func_177956_o() - 2), (int)(pos.func_177952_p() - 3), (int)(pos.func_177958_n() + 3), (int)(pos.func_177956_o() + 2), (int)(pos.func_177952_p() + 3))) {
                    if (!BananaPlantFeature.isGrass((IWorldGenerationBaseReader)world, blockpos) || random.nextInt(4) != 0 || !TreeUtil.isAir((IWorldGenerationBaseReader)world, (BlockPos)blockpos.func_177984_a())) continue;
                    TreeUtil.setForcedState((IWorldWriter)world, (BlockPos)blockpos, (BlockState)Blocks.field_150351_n.func_176223_P());
                }
            }
            return true;
        }
        return false;
    }

    private static boolean isAirAt(IWorldGenerationBaseReader world, BlockPos pos, int size) {
        BlockPos position = pos.func_177984_a();
        for (int i = 0; i < size + 1; ++i) {
            if (!TreeUtil.isAir((IWorldGenerationBaseReader)world, (BlockPos)position)) {
                return false;
            }
            for (Direction direction : Direction.values()) {
                if (!direction.func_176740_k().func_176722_c() || TreeUtil.isAir((IWorldGenerationBaseReader)world, (BlockPos)position.func_177972_a(direction))) continue;
                return false;
            }
            position = position.func_177984_a();
        }
        return true;
    }

    public static boolean isGrowable(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, state -> state.func_203425_a(Blocks.field_150351_n) || state.func_203425_a(Blocks.field_150354_m));
    }

    public static boolean isValidGround(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, state -> state.func_203425_a(Blocks.field_150351_n) || state.func_203425_a(Blocks.field_150354_m) || state.func_203425_a(Blocks.field_196658_i));
    }

    public static boolean isGrass(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, state -> state.func_203425_a(Blocks.field_196658_i));
    }
}

